/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.config;

import net.minecraftforge.common.ForgeConfigSpec;

public final class MutantShulkerTurretCommonConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Double> mutant_shulker_bullet_damage;
    public static final ForgeConfigSpec.ConfigValue<Boolean> mutant_shulker_bullet_griefing;
    public static final ForgeConfigSpec.ConfigValue<Boolean> mutant_shulker_bullet_griefing_drops_blocks;
    public static final ForgeConfigSpec.ConfigValue<Double> mutant_shulker_bullet_explosion_size;
    public static final ForgeConfigSpec.ConfigValue<Integer> mutant_shulker_bullet_levitation_length;
    public static final ForgeConfigSpec.ConfigValue<Integer> mutant_shulker_bullet_levitation_level;
    public static final ForgeConfigSpec.ConfigValue<Double> shulker_bullet_damage;
    public static final ForgeConfigSpec.ConfigValue<Integer> shulker_bullet_levitation_length;
    public static final ForgeConfigSpec.ConfigValue<Integer> shulker_bullet_levitation_level;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ignores_levitating_mobs;
    public static final ForgeConfigSpec.ConfigValue<Integer> shoot_cooldown;
    public static final ForgeConfigSpec.ConfigValue<Boolean> locked_horizontal_movement;
    public static final ForgeConfigSpec.ConfigValue<Double> max_health;
    public static final ForgeConfigSpec.ConfigValue<Integer> repair_heal_percent;
    public static final ForgeConfigSpec.ConfigValue<Double> knockback_resistance;
    public static final ForgeConfigSpec.ConfigValue<Double> armour;
    public static final ForgeConfigSpec.ConfigValue<Double> armour_toughness;
    public static final ForgeConfigSpec.ConfigValue<Double> follow_range;
    public static final ForgeConfigSpec.ConfigValue<Boolean> friendly_fire;

    static {
        BUILDER.comment("Configure Mutant More's Mutant Shulker Turret on client and server side (these changes will affect everyone in the world)! The game needs to be restarted for changes to take effect!");
        mutant_shulker_bullet_damage = BUILDER.comment("\n The damage dealt to mobs caught in the explosion caused when a Mutant Shulker Bullet fired by the Mutant Shulker Turret collides with blocks or mobs\n usually set to 8.0").define("Mutant Shulker Bullet Damage", (Object)8.0);
        mutant_shulker_bullet_griefing = BUILDER.comment("\n If Mutant Shulker Bullets fired by the Mutant Shulker Turret destroy blocks when they explode\n usually set to false").define("Mutant Shulker Bullet Griefing", false);
        mutant_shulker_bullet_griefing_drops_blocks = BUILDER.comment("\n If blocks destroyed by Mutant Shulker Bullets fired by the Mutant Shulker Turret exploding drop themselves as items, allowing them to be recovered, impacts performance\n usually set to true").define("Mutant Shulker Bullet Griefing Drops Blocks", true);
        mutant_shulker_bullet_explosion_size = BUILDER.comment("\n The size of explosions caused when Mutant Shulker Bullets fired by the Mutant Shulker Turret collide with blocks or mobs\n usually set to 2.0").define("Mutant Shulker Bullet Explosion Size", (Object)2.0);
        mutant_shulker_bullet_levitation_length = BUILDER.comment("\n The length in ticks (20 ticks in a second) that the Levitation effect is applied to mobs hit by Mutant Shulker Bullets fired by the Mutant Shulker Turret for\n usually set to 100 ticks (5 seconds)").define("Mutant Shulker Bullet Levitation Length", (Object)100);
        mutant_shulker_bullet_levitation_level = BUILDER.comment("\n The level of the Levitation effect applied to mobs hit by Mutant Shulker Bullets fired by the Mutant Shulker Turret\n usually set to 3 (Levitation 4)").define("Mutant Shulker Bullet Levitation Level", (Object)3);
        shulker_bullet_damage = BUILDER.comment("\n The damage dealt to mobs hit by a Shulker Bullet fired by the Mutant Shulker Turret collides with blocks or mobs\n usually set to 4.0").define("Shulker Bullet Damage", (Object)4.0);
        shulker_bullet_levitation_length = BUILDER.comment("\n The length in ticks (20 ticks in a second) that the Levitation effect is applied to mobs hit by Shulker Bullets fired by the Mutant Shulker Turret for\n usually set to 200 ticks (10 seconds)").define("Shulker Bullet Levitation Length", (Object)200);
        shulker_bullet_levitation_level = BUILDER.comment("\n The level of the Levitation effect applied to mobs hit by Shulker Bullets fired by the Mutant Shulker Turret\n usually set to 0 (Levitation 1)").define("Shulker Bullet Levitation Level", (Object)0);
        ignores_levitating_mobs = BUILDER.comment("\n If the Mutant Shulker Turret stops targeting mobs that it has caused to levitate and starts to target mobs that still don't have the Levitation effect instead\n usually set to true").define("Ignores Levitating Mobs", true);
        shoot_cooldown = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that each of the Mutant Shulker Turret's heads has to wait after shooting before it can shoot again\n usually set to 60 ticks (3 seconds)").define("Shoot Cooldown", (Object)60);
        locked_horizontal_movement = BUILDER.comment("\n If the Mutant Shulker Turret's horizontal movement is locked, preventing it from being moved on the X or Z axis, helps keep the Mutant Shulker Turret in one place\n usually set to true").define("Locked Horizontal Movement", true);
        max_health = BUILDER.comment("\n The Mutant Shulker Turret's max health\n usually set to 200.0").define("Max Health", (Object)200.0);
        repair_heal_percent = BUILDER.comment("\n The percent of max health that the Mutant Shulker Turret is healed when repaired using a valid item\n usually set to 50%").define("Repair Heal Percent", (Object)50);
        knockback_resistance = BUILDER.comment("\n The Mutant Shulker Turret's resistance to attack knockback\n usually set to 1.0 (immune to knockback)").define("Knockback Resistance", (Object)1.0);
        armour = BUILDER.comment("\n The Mutant Shulker Turret's armour value\n usually set to 10.0").define("Armour", (Object)10.0);
        armour_toughness = BUILDER.comment("\n The Mutant Shulker Turret's armour toughness value\n usually set to 0.0").define("Armour Toughness", (Object)0.0);
        follow_range = BUILDER.comment("\n The distance that the Mutant Shulker Turret can target mobs from\n usually set to 30.0").define("Follow Range", (Object)30.0);
        friendly_fire = BUILDER.comment("\n If the Mutant Shulker Turret can harm mobs that it can't target\n usually set to false").define("Friendly Fire", false);
        SPEC = BUILDER.build();
    }
}

